PROC TABULATE DATA=ghpb15  MISSING NOSEPS;                                                                                                                                                      
CLASS PART8 INS3 ENT2 filingsize2 / PRELOADFMT;
VAR dup_wgt;
title 'Table A9. Distribution of Group Health Plans';
title2 'by type of insurance, type of plan, and number of participants, 2015';
title3 'All Plans';
TABLE  	ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. PART8=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-' box='Number of Participants';
RUN; 

PROC TABULATE DATA=ghpb15 MISSING NOSEPS;
CLASS PART8 INS3 ENT2 filingsize2 / PRELOADFMT;
weight dup_wgt;
VAR TPART; 
title 'Table A9. Contd: Per Plan Statistics'; 
title2 'All Plans';                                                                                                                                                                                                                                                                                                                                                                                
Table   tpart='Mean Number of Participants'*mean=' '*f=comma12.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-'; 
Table   tpart='Median Number of Participants'*median=' '*f=comma12.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-'; 
RUN; 

PROC TABULATE DATA=ghpb15  MISSING NOSEPS;                                                                                                                                                      
where filingsize2='1';
CLASS PART8 INS3 ENT2 filingsize2 / PRELOADFMT;
VAR dup_wgt;
title 'Table A9. Distribution of Group Health Plans';
title2 'by type of insurance, type of plan, and number of participants, 2015';
title3 'Plans with Trusts';
TABLE  	ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. PART8=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-' box='Number of Participants';
RUN; 

PROC TABULATE DATA=ghpb15 MISSING NOSEPS;
where filingsize2='1';
CLASS PART8 INS3 ENT2 filingsize2 / PRELOADFMT;
weight dup_wgt;
VAR TPART; 
title 'Table A9. Contd: Per Plan Statistics'; 
title2 'Plans with Trusts';                                                                                                                                                                                                                                                                                                                                                                                 
Table   tpart='Mean Number of Participants'*mean=' '*f=comma12.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-'; 
Table   tpart='Median Number of Participants'*median=' '*f=comma12.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-'; 
RUN; 

PROC TABULATE DATA=ghpb15  MISSING NOSEPS;                                                                                                                                                      
where filingsize2='2';
CLASS PART8 INS3 ENT2 filingsize2 / PRELOADFMT;
VAR dup_wgt;
title 'Table A9. Distribution of Group Health Plans';
title2 'by type of insurance, type of plan, and number of participants, 2015';
title3 'Plans with No Trusts';
TABLE  	ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. PART8=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-' box='Number of Participants';
RUN; 

PROC TABULATE DATA=ghpb15 MISSING NOSEPS;
where filingsize2='2';
CLASS PART8 INS3 ENT2 filingsize2 / PRELOADFMT;
weight dup_wgt;
VAR TPART; 
title 'Table A9. Contd: Per Plan Statistics'; 
title2 'Plans with No Trusts';                                                                                                                                                                                                                                                                                                                                                                               
Table   tpart='Mean Number of Participants'*mean=' '*f=comma12.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-'; 
Table   tpart='Median Number of Participants'*median=' '*f=comma12.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-'; 
RUN; 
